﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VIRP_WEB.BaseCode;

namespace VIRP_WEB.Controls.Custom.BPR
{
    public partial class controls_BaseControlRadioButtonListTextValue : System.Web.UI.UserControl
    {
        private ServiceInterfaceManager _manager = new ServiceInterfaceManager();

        protected void Page_Load(object sender, EventArgs e)
        {

        }
        public string Text
        {
            get
            {
                return HiddenFieldID.Value;
            }
            set
            {
                if (!string.IsNullOrEmpty(value))
                {
                    HiddenFieldID.Value = value;
                    foreach (ListItem radioListItem in RadioButtonListID.Items)
                    {
                        if (radioListItem.Value == value.Trim())
                        {
                            radioListItem.Selected = true;
                            break;
                        }
                    }
                }
            }
        }

        public string Description
        {
            get
            {
                string results = string.Empty;

                foreach (ListItem radioListItem in RadioButtonListID.Items)
                {
                    if (radioListItem.Value == HiddenFieldID.Value.Trim())
                    {
                        results = radioListItem.Text;
                        break;
                    }
                }

                return results;
            }
        }

        public string LabelText
        {
            get
            {
                return LabelforLabelID.Text;
            }
            set
            {
                LabelforLabelID.Text = value;
            }
        }

        public bool Enabled
        {
            set
            {
                this.RadioButtonListID.Enabled = value;
            }
        }

        public string Tooltip
        {
            set
            {
                LabelforLabelID.ToolTip = value;
                RadioButtonListID.ToolTip = value;
            }
        }

        public bool IncludeLabel
        {
            set
            {
                LabelforLabelID.Visible = value;
            }
        }

        public string LookUpCategory
        {
            set
            {
                if (!string.IsNullOrEmpty(value))
                {
                    var manager = new ServiceInterfaceManager();
                    var lookupList = manager.SelectLookupList(value);

                    RadioButtonListID.DataSource = lookupList;
                    RadioButtonListID.DataValueField = "CODE";
                    RadioButtonListID.DataTextField = "NAME";
                    RadioButtonListID.DataBind();
                    AddAttributes();
                }
            }
        }

        /// <summary>
        /// Set Required validator
        /// </summary>
        public bool IsRequired
        {
            set
            {
                if (value)
                {
                    RequiredFieldValidatorID.Visible = true;
                    RequiredFieldValidatorID.Enabled = true;
                }
                else
                {
                    RequiredFieldValidatorID.Visible = false;
                    RequiredFieldValidatorID.Enabled = false;
                }
            }
        }

        /// <summary>
        /// Set the validationErrorMessage
        /// </summary>
        public string ValidationErrorMessage
        {
            set
            {
                if (!string.IsNullOrEmpty(value))
                {
                    RequiredFieldValidatorID.ErrorMessage = value;
                }
            }
        }

        /// <summary>
        /// Set validation group
        /// </summary>
        public string ValidationGroup
        {
            set
            {
                if (!string.IsNullOrEmpty(value))
                {
                    RequiredFieldValidatorID.ValidationGroup = value;
                }
            }
        }
        public void LoadControlsFromObject(string text, string labelText, string tooltip, bool includeLabel, string lookupCategory, string validationGroup, string validationErrorMsg, bool isRequired)
        {
            if (!string.IsNullOrEmpty(tooltip))
            {
                Tooltip = tooltip;
            }
            if (!string.IsNullOrEmpty(labelText))
            {
                LabelText = labelText;
            }

            IncludeLabel = includeLabel;
            LookUpCategory = lookupCategory;
            if (!string.IsNullOrEmpty(text))
            {
                Text = text;
            }
            ValidationGroup = validationGroup;
            ValidationErrorMessage = validationErrorMsg;
            IsRequired = isRequired;
        }

        private void AddAttributes()
        {
            foreach (ListItem radioButton in RadioButtonListID.Items)
            {
                if (radioButton.Attributes["onclick"] == null)
                {
                    radioButton.Attributes.Add("onclick",
                        "SetBaseControlTextValue(this, '" + HiddenFieldID.ClientID + "')");
                }
            }
        }
    }
}